!Object constantsFor: 'Geos Libraries'!

geosLIB30 'SYSTEM\imagev'! !

!Object constantsFor: 'Geos vardata'!

!

!Object constantsFor: 'Geos messages'!

line 27136!
gifBackround 27137!
msgRotate 27138!
in 27139!
out 27140!
zoom 27141!
msgFread 27142!
bitmap 27143!
up 27144!
imageSize 27145!
imageSize 27146!
compFileSize 27147!
imageInfo 27148!
errorFlag 27149!
viewer 27150!
mouseCross 27151!
indicator 27152!
active 27153!
active 27154!
coordinates 27155!
getZoomedCoordinates 27156!
status 27157!
getCaller 27158!
scale 27136!
close 27648!
getPrintterController 27649!
getPrintterInfo 27650!
setPrintterInfo 27651!
copy 28160!
delete 28161!
drawLine 28162!
zoomin 28163!
zoomout 28164!
rotate 28165!
cleanUp 28166!
setErrorFlag 28167!
initViewer 28168!
setScale 28169!
dimmAction 28170!
printterController 28171!
getImageInfo 28172!
apply 28173!
zoomlevel 28174!
!

!Geos class methodsFor: 'library calls'!

ImageViewerConvertToBitmap: info with: bitMapFile with: bitMapBlock
	"ImageViewerDrawStatus cdecl ImageViewerConvertToBitmap( DocumentInfo *info, VMFileHandle *bitMapFile, VMBlockHandle *bitMapBlock) in internal/resp/imgctrl.goh"
	^GEOS call: info with: bitMapFile with: bitMapBlock with: #[158 0 4 3 3 3 1]!

ImageViewerConvertToBitmapAndGiveSize: info with: bitMapFile with: ptcVMFileName with: bitMapBlock with: pwHeight with: pwWidth with: pwZoomValue
	"ImageViewerDrawStatus cdecl ImageViewerConvertToBitmapAndGiveSize( DocumentInfo *info, VMFileHandle *bitMapFile, TCHAR *ptcVMFileName, VMBlockHandle *bitMapBlock, word *pwHeight, word *pwWidth, word *pwZoomValue) in internal/resp/imgctrl.goh"
	^GEOS call: info with: bitMapFile with: ptcVMFileName with: bitMapBlock with: pwHeight with: pwWidth with: pwZoomValue with: #[158 0 5 3 3 3 3 3 3 3 1]!

ImageViewerDrawBitmapToGState: info with: gstate with: pwHeight with: pwWidth with: pwZoomValue
	"ImageViewerDrawStatus cdecl ImageViewerDrawBitmapToGState(DocumentInfo *info, GStateHandle gstate, word *pwHeight, word *pwWidth, word *pwZoomValue) in internal/resp/imgctrl.goh"
	^GEOS call: info with: gstate with: pwHeight with: pwWidth with: pwZoomValue with: #[158 0 6 3 1 3 3 3 1]!

ImageViewerCleanUp
	"void cdecl ImageViewerCleanUp(void) in internal/resp/imgctrl.goh"
	^GEOS call: #[158 0 7 0]!

!

GenGadget subclass: #Image
	instanceVariableNames: ''
	classVariableNames: ''!

GenContent subclass: #ImageContent
	instanceVariableNames: ''
	classVariableNames: ''!

GenInteraction subclass: #ImageInteraction
	instanceVariableNames: ''
	classVariableNames: ''!

GenView subclass: #ImageView
	instanceVariableNames: ''
	classVariableNames: ''!

TwoLevelTrigger subclass: #FirstLevelTrigger
	instanceVariableNames: ''
	classVariableNames: ''!

ViewerDialog subclass: #ImageDialog
	instanceVariableNames: ''
	classVariableNames: ''!

TwoLevelTrigger subclass: #SecondLevelTrigger
	instanceVariableNames: ''
	classVariableNames: ''!

ViewerControl subclass: #ImageViewerControl
	instanceVariableNames: ''
	classVariableNames: ''!

!Image comment!
Library imagev, file internal/resp/imgctrl.goh! !

!Image class methodsFor: 'library linkage'!

library
	^30!

entry
	^000d!
!

!Image methodsFor: 'Geos instance variables'!

work_gstate
	"@instance GStateHandle work_gstate"
	^self wordAt: 19!

work_gstate: value
	"@instance GStateHandle work_gstate"
	^self wordAt: 19 put: value!

bitmap_gstate
	"@instance GStateHandle bitmap_gstate"
	^self wordAt: 21!

bitmap_gstate: value
	"@instance GStateHandle bitmap_gstate"
	^self wordAt: 21 put: value!

image_type
	"@instance word image_type"
	^self wordAt: 23!

image_type: value
	"@instance word image_type"
	^self wordAt: 23 put: value!

caller_type
	"@instance word caller_type"
	^self wordAt: 25!

caller_type: value
	"@instance word caller_type"
	^self wordAt: 25 put: value!

input_file_handle
	"@instance FileHandle input_file_handle"
	^self wordAt: 27!

input_file_handle: value
	"@instance FileHandle input_file_handle"
	^self wordAt: 27 put: value!

file_info
	"@instance DocumentInfo file_info"
	^GCSDocumentInfo forPointer: (self ptrAt: 29).!

file_info: aBlock
	"@instance DocumentInfo file_info"
	aBlock value: (GCSDocumentInfo forPointer: (self ptrAt: 29)).!

input_file_size
	"@instance dword input_file_size"
	^self dwordAt: 67!

input_file_size: value
	"@instance dword input_file_size"
	^self dwordAt: 67 put: value!

file_format
	"@instance byte file_format"
	^self byteAt: 71!

file_format: value
	"@instance byte file_format"
	^self byteAt: 71 put: value!

rotation
	"@instance word rotation"
	^self wordAt: 72!

rotation: value
	"@instance word rotation"
	^self wordAt: 72 put: value!

translation_x
	"@instance word translation_x"
	^self wordAt: 74!

translation_x: value
	"@instance word translation_x"
	^self wordAt: 74 put: value!

translation_y
	"@instance word translation_y"
	^self wordAt: 76!

translation_y: value
	"@instance word translation_y"
	^self wordAt: 76 put: value!

zoom
	"@instance word zoom"
	^self wordAt: 78!

zoom: value
	"@instance word zoom"
	^self wordAt: 78 put: value!

decompress_zoom
	"@instance word decompress_zoom"
	^self wordAt: 80!

decompress_zoom: value
	"@instance word decompress_zoom"
	^self wordAt: 80 put: value!

width
	"@instance word width"
	^self wordAt: 82!

width: value
	"@instance word width"
	^self wordAt: 82 put: value!

height
	"@instance word height"
	^self wordAt: 84!

height: value
	"@instance word height"
	^self wordAt: 84 put: value!

vert_pos
	"@instance word vert_pos"
	^self wordAt: 86!

vert_pos: value
	"@instance word vert_pos"
	^self wordAt: 86 put: value!

block_handle
	"@instance VMBlockHandle block_handle"
	^self wordAt: 88!

block_handle: value
	"@instance VMBlockHandle block_handle"
	^self wordAt: 88 put: value!

file_handle
	"@instance VMFileHandle file_handle"
	^self wordAt: 90!

file_handle: value
	"@instance VMFileHandle file_handle"
	^self wordAt: 90 put: value!

file_name
	"@instance byte[15] file_name"
	"#pointer [92, 15]"
	^self!

error_flag
	"@instance word error_flag"
	^self wordAt: 107!

error_flag: value
	"@instance word error_flag"
	^self wordAt: 107 put: value!

temp_file_still_exist
	"@instance byte temp_file_still_exist"
	^self byteAt: 109!

temp_file_still_exist: value
	"@instance byte temp_file_still_exist"
	^self byteAt: 109 put: value!

x_coordinate
	"@instance sword x_coordinate"
	^self wordAt: 110!

x_coordinate: value
	"@instance sword x_coordinate"
	^self wordAt: 110 put: value!

y_coordinate
	"@instance sword y_coordinate"
	^self wordAt: 112!

y_coordinate: value
	"@instance sword y_coordinate"
	^self wordAt: 112 put: value!

x_coordinate_old
	"@instance sword x_coordinate_old"
	^self wordAt: 114!

x_coordinate_old: value
	"@instance sword x_coordinate_old"
	^self wordAt: 114 put: value!

y_coordinate_old
	"@instance sword y_coordinate_old"
	^self wordAt: 116!

y_coordinate_old: value
	"@instance sword y_coordinate_old"
	^self wordAt: 116 put: value!

need_mouse_cross
	"@instance byte need_mouse_cross"
	^self byteAt: 118!

need_mouse_cross: value
	"@instance byte need_mouse_cross"
	^self byteAt: 118 put: value!

last_press
	"@instance byte last_press"
	^self byteAt: 119!

last_press: value
	"@instance byte last_press"
	^self byteAt: 119 put: value!

pixels_to_move
	"@instance byte pixels_to_move"
	^self byteAt: 120!

pixels_to_move: value
	"@instance byte pixels_to_move"
	^self byteAt: 120 put: value!

first_draw
	"@instance byte first_draw"
	^self byteAt: 121!

first_draw: value
	"@instance byte first_draw"
	^self byteAt: 121 put: value!

need_indicator
	"@instance byte need_indicator"
	^self byteAt: 122!

need_indicator: value
	"@instance byte need_indicator"
	^self byteAt: 122 put: value!

black_left
	"@instance word black_left"
	^self wordAt: 123!

black_left: value
	"@instance word black_left"
	^self wordAt: 123 put: value!

black_top
	"@instance word black_top"
	^self wordAt: 125!

black_top: value
	"@instance word black_top"
	^self wordAt: 125 put: value!

black_right
	"@instance word black_right"
	^self wordAt: 127!

black_right: value
	"@instance word black_right"
	^self wordAt: 127 put: value!

black_bottom
	"@instance word black_bottom"
	^self wordAt: 129!

black_bottom: value
	"@instance word black_bottom"
	^self wordAt: 129 put: value!

white_left
	"@instance word white_left"
	^self wordAt: 131!

white_left: value
	"@instance word white_left"
	^self wordAt: 131 put: value!

white_top
	"@instance word white_top"
	^self wordAt: 133!

white_top: value
	"@instance word white_top"
	^self wordAt: 133 put: value!

white_right
	"@instance word white_right"
	^self wordAt: 135!

white_right: value
	"@instance word white_right"
	^self wordAt: 135 put: value!

white_bottom
	"@instance word white_bottom"
	^self wordAt: 137!

white_bottom: value
	"@instance word white_bottom"
	^self wordAt: 137 put: value!

gray_left
	"@instance word gray_left"
	^self wordAt: 139!

gray_left: value
	"@instance word gray_left"
	^self wordAt: 139 put: value!

gray_top
	"@instance word gray_top"
	^self wordAt: 141!

gray_top: value
	"@instance word gray_top"
	^self wordAt: 141 put: value!

gray_right
	"@instance word gray_right"
	^self wordAt: 143!

gray_right: value
	"@instance word gray_right"
	^self wordAt: 143 put: value!

gray_bottom
	"@instance word gray_bottom"
	^self wordAt: 145!

gray_bottom: value
	"@instance word gray_bottom"
	^self wordAt: 145 put: value!

first_total_update
	"@instance word first_total_update"
	^self wordAt: 147!

first_total_update: value
	"@instance word first_total_update"
	^self wordAt: 147 put: value!

last_total_update
	"@instance word last_total_update"
	^self wordAt: 149!

last_total_update: value
	"@instance word last_total_update"
	^self wordAt: 149 put: value!

zoom_ratio
	"@instance word zoom_ratio"
	^self wordAt: 151!

zoom_ratio: value
	"@instance word zoom_ratio"
	^self wordAt: 151 put: value!

!

!Image methodsFor: 'Geos vardata'!

!

!Image methodsFor: 'Geos messages'!

line: x_offset with: y_offset with: position with: line with: length
	"@message word MSG_DRAW_LINE(word x_offset, word y_offset,word position,byte* line, word length)"
	^self geosMessage: #[106 0 1 0 1 1 1 3 1 1] with: x_offset with: y_offset with: position with: line with: length!

gifBackround
	"@message void MSG_DRAW_GIF_BACKROUND()"
	^self geosMessage: #[106 1 2 0 0]!

msgRotate
	"@message void MSG_ROTATE()"
	^self geosMessage: #[106 2 2 0 0]!

in
	"@message void MSG_ZOOM_IN()"
	^self geosMessage: #[106 3 2 0 0]!

out
	"@message void MSG_ZOOM_OUT()"
	^self geosMessage: #[106 4 2 0 0]!

zoom
	"@message word MSG_GET_ZOOM()"
	^self geosMessage: #[106 5 2 0 1]!

msgFread: dest with: number_of_bytes
	"@message word MSG_FREAD(byte* dest,word number_of_bytes)"
	^self geosMessage: #[106 6 1 0 3 1 1] with: dest with: number_of_bytes!

bitmap: width with: height
	"@message word MSG_CREATE_BITMAP(word width, word height)"
	^self geosMessage: #[106 7 1 0 1 1 1] with: width with: height!

up
	"@message word MSG_CLEAN_UP()"
	^self geosMessage: #[106 8 2 0 1]!

imageSize: width with: height
	"@message void MSG_SET_IMAGE_SIZE(word width, word height)"
	^self geosMessage: #[106 9 1 0 1 1 0] with: width with: height!

imageSize: info
	"@message void MSG_GET_IMAGE_SIZE(struct image_info *info)"
	^self geosMessage: #[106 10 1 0 3 0] with: info!

compFileSize
	"@message dword MSG_GET_COMP_FILE_SIZE()"
	^self geosMessage: #[106 11 2 0 2]!

imageInfo: info
	"@message void MSG_GET_IMAGE_INFO(DocumentInfo *info)"
	^self geosMessage: #[106 12 1 0 3 0] with: info!

errorFlag: value
	"@message void MSG_SET_ERROR_FLAG(word value)"
	^self geosMessage: #[106 13 1 0 1 0] with: value!

viewer: size_info with: info with: inline_flag with: caller_app
	"@message void MSG_INIT_VIEWER(struct image_info *size_info, DocumentInfo *info, word inline_flag, word caller_app)"
	^self geosMessage: #[106 14 1 0 3 3 1 1 0] with: size_info with: info with: inline_flag with: caller_app!

mouseCross: draw_once
	"@message void MSG_DRAW_MOUSE_CROSS(byte draw_once)"
	^self geosMessage: #[106 15 1 0 1 0] with: draw_once!

indicator: position with: progress with: total_width
	"@message void MSG_UPDATE_INDICATOR(word position, word progress, word total_width)"
	^self geosMessage: #[106 16 1 0 1 1 1 0] with: position with: progress with: total_width!

active
	"@message word MSG_SET_ACTIVE()"
	^self geosMessage: #[106 17 2 0 1]!

active
	"@message word MSG_RELEASE_ACTIVE()"
	^self geosMessage: #[106 18 2 0 1]!

coordinates: cross_coordinates
	"@message void MSG_IMAGE_COORDINATES(struct image_info *cross_coordinates)"
	^self geosMessage: #[106 19 1 0 3 0] with: cross_coordinates!

getZoomedCoordinates: cross_coordinates
	"@message void MSG_IMAGE_GET_ZOOMED_COORDINATES(struct image_info *cross_coordinates)"
	^self geosMessage: #[106 20 1 0 3 0] with: cross_coordinates!

status
	"@message word MSG_IMAGE_STATUS()"
	^self geosMessage: #[106 21 2 0 1]!

getCaller
	"@message word MSG_IMAGE_GET_CALLER()"
	^self geosMessage: #[106 22 2 0 1]!

!

!ImageContent comment!
Library imagev, file internal/resp/imgctrl.goh! !

!ImageContent class methodsFor: 'library linkage'!

library
	^30!

entry
	^000c!
!

!ImageContent methodsFor: 'Geos instance variables'!

!

!ImageContent methodsFor: 'Geos vardata'!

!

!ImageContent methodsFor: 'Geos messages'!

!

!ImageInteraction comment!
Library imagev, file internal/resp/imgctrl.goh! !

!ImageInteraction class methodsFor: 'library linkage'!

library
	^30!

entry
	^0009!
!

!ImageInteraction methodsFor: 'Geos instance variables'!

!

!ImageInteraction methodsFor: 'Geos vardata'!

!

!ImageInteraction methodsFor: 'Geos messages'!

!

!ImageView comment!
Library imagev, file internal/resp/imgctrl.goh! !

!ImageView class methodsFor: 'library linkage'!

library
	^30!

entry
	^000b!
!

!ImageView methodsFor: 'Geos instance variables'!

scroll_ratio
	"@instance sdword scroll_ratio"
	^self dwordAt: 83!

scroll_ratio: value
	"@instance sdword scroll_ratio"
	^self dwordAt: 83 put: value!

!

!ImageView methodsFor: 'Geos vardata'!

!

!ImageView methodsFor: 'Geos messages'!

scale: scale
	"@message void MSG_SET_SCALE(word scale)"
	^self geosMessage: #[106 0 1 0 1 0] with: scale!

!

!FirstLevelTrigger comment!
Library imagev, file internal/resp/imgctrl.goh! !

!FirstLevelTrigger class methodsFor: 'library linkage'!

library
	^30!

entry
	^000e!
!

!FirstLevelTrigger methodsFor: 'Geos instance variables'!

!

!FirstLevelTrigger methodsFor: 'Geos vardata'!

!

!FirstLevelTrigger methodsFor: 'Geos messages'!

!

!ImageDialog comment!
Library imagev, file internal/resp/imgctrl.goh! !

!ImageDialog class methodsFor: 'library linkage'!

library
	^30!

entry
	^0008!
!

!ImageDialog methodsFor: 'Geos instance variables'!

need_printer
	"@instance byte need_printer"
	^self byteAt: 33!

need_printer: value
	"@instance byte need_printer"
	^self byteAt: 33 put: value!

!

!ImageDialog methodsFor: 'Geos vardata'!

!

!ImageDialog methodsFor: 'Geos messages'!

close
	"@message void MSG_IMAGE_CLOSE()"
	^self geosMessage: #[108 0 2 0 0]!

getPrintterController
	"@message optr MSG_DIALOG_GET_PRINTTER_CONTROLLER()"
	^self geosMessage: #[108 1 2 0 2]!

getPrintterInfo
	"@message byte MSG_DIALOG_GET_PRINTTER_INFO()"
	^self geosMessage: #[108 2 2 0 1]!

setPrintterInfo: info
	"@message void MSG_DIALOG_SET_PRINTTER_INFO(byte info)"
	^self geosMessage: #[108 3 1 0 1 0] with: info!

!

!SecondLevelTrigger comment!
Library imagev, file internal/resp/imgctrl.goh! !

!SecondLevelTrigger class methodsFor: 'library linkage'!

library
	^30!

entry
	^000f!
!

!SecondLevelTrigger methodsFor: 'Geos instance variables'!

!

!SecondLevelTrigger methodsFor: 'Geos vardata'!

!

!SecondLevelTrigger methodsFor: 'Geos messages'!

!

!ImageViewerControl comment!
Library imagev, file internal/resp/imgctrl.goh! !

!ImageViewerControl class methodsFor: 'library linkage'!

library
	^30!

entry
	^000a!
!

!ImageViewerControl methodsFor: 'Geos instance variables'!

!

!ImageViewerControl methodsFor: 'Geos vardata'!

!

!ImageViewerControl methodsFor: 'Geos messages'!

copy
	"@message void MSG_IMAGE_COPY()"
	^self geosMessage: #[110 0 2 0 0]!

delete
	"@message void MSG_IMAGE_DELETE()"
	^self geosMessage: #[110 1 2 0 0]!

drawLine: position with: line with: length
	"@message word MSG_CONT_DRAW_LINE(word position,byte* line, word length)"
	^self geosMessage: #[110 2 1 0 1 3 1 1] with: position with: line with: length!

zoomin
	"@message void MSG_IMAGE_ZOOMIN()"
	^self geosMessage: #[110 3 2 0 0]!

zoomout
	"@message void MSG_IMAGE_ZOOMOUT()"
	^self geosMessage: #[110 4 2 0 0]!

rotate
	"@message void MSG_IMAGE_ROTATE()"
	^self geosMessage: #[110 5 2 0 0]!

cleanUp
	"@message word MSG_CONT_CLEAN_UP()"
	^self geosMessage: #[110 6 2 0 1]!

setErrorFlag: value
	"@message void MSG_CONT_SET_ERROR_FLAG(word value)"
	^self geosMessage: #[110 7 1 0 1 0] with: value!

initViewer: size_info with: info with: inline_flag with: caller_app
	"@message void MSG_CONT_INIT_VIEWER(struct image_info *size_info, DocumentInfo *info, word inline_flag, word caller_app)"
	^self geosMessage: #[110 8 1 0 3 3 1 1 0] with: size_info with: info with: inline_flag with: caller_app!

setScale: zoom
	"@message void MSG_CONT_SET_SCALE(word zoom)"
	^self geosMessage: #[110 9 1 0 1 0] with: zoom!

dimmAction: dimm_state
	"@message void MSG_CONT_DIMM_ACTION(word dimm_state )"
	^self geosMessage: #[110 10 1 0 1 0] with: dimm_state!

printterController
	"@message optr MSG_GET_PRINTTER_CONTROLLER()"
	^self geosMessage: #[110 11 2 0 2]!

getImageInfo: info
	"@message void MSG_CONT_GET_IMAGE_INFO(DocumentInfo *info)"
	^self geosMessage: #[110 12 1 0 3 0] with: info!

apply: wId
	"@message void MSG_IM_APPLY(word wId)"
	^self geosMessage: #[110 13 1 0 1 0] with: wId!

zoomlevel: pwZoom
	"@message void MSG_IMAGE_ZOOMLEVEL(word *pwZoom)"
	^self geosMessage: #[110 14 1 0 3 0] with: pwZoom!

!

